#include <stdio.h>
#include <stdlib.h>


#define BLOCKLEN 32000
#define DATALEN 32000

typedef struct linestruct
{
	struct linestruct *next;
	int line;
	int blockptr;
	char *the_str;
} LINE;

	LINE *linebase;
	unsigned char block[BLOCKLEN];
	int blockptr;
	unsigned char data[DATALEN];
	int dataptr;
	char the_str[1024];
	int the_ptr;


  /* Starting at 0x80 */

char applesoft_tokens[][8] =
{
/* 80 */ "END", "FOR", "NEXT", "DATA", "INPUT", "DEL", "DIM", "READ", 
/* 88 */ "GR", "TEXT", "PR #", "IN #", "CALL", "PLOT", "HLIN", "VLIN", 
/* 90 */ "HGR2", "HGR", "HCOLOR=", "HPLOT", "DRAW", "XDRAW", "HTAB", "HOME", 
/* 98 */ "ROT=", "SCALE=", "SHLOAD", "TRACE", "NOTRACE", "NORMAL", "INVERSE", "FLASH", 
/* A0 */ "COLOR=", "POP", "VTAB ", "HIMEM:", "LOMEM:", "ONERR", "RESUME", "RECALL", 
/* A8 */ "STORE", "SPEED=", "LET", "GOTO", "RUN", "IF", "RESTORE", "&", 
/* B0 */ "GOSUB", "RETURN", "REM", "STOP", "ON", "WAIT", "LOAD", "SAVE", 
/* B8 */ "DEF", "POKE", "PRINT", "CONT", "LIST", "CLEAR", "GET", "NEW", 
/* C0 */ "TAB (", "TO", "FN", "SPC(", "THEN", "AT", "NOT", "STEP", 
/* C8 */ "+", "-", "*", "/", "^", "AND", "OR", ">", 
/* D0 */ "=", "<", "SGN", "INT", "ABS", "USR", "FRE", "SCRN (", 
/* D8 */ "PDL", "POS", "SQR", "RND", "LOG", "EXP", "COS", "SIN", 
/* E0 */ "TAN", "ATN", "PEEK", "LEN", "STR$", "VAL", "ASC", "CHR$", 
/* E8 */ "LEFT$", "RIGHT$", "MID$", "", "", "", "", "", 
/* F0 */ "", "", "", "", "", "", "", "", 
/* F8 */ "", "", "", "", "", "(", "(", "("
};

/*
Integer Basic
      $03: :
      $04: LOAD
      $05: SAVE
      $07: RUN
      $09: DEL
      $0A: , 
      $0B: NEW
      $0C: CLR
      $0D: AUTO
      $0F: MAN
      $10: HIMEM:
      $11: LOMEM:
      $12: +
      $13: -
      $14: *
      $15: /
      $16: =
      $17: #
      $18: >=
      $19: >
      $1A: <=
      $1B: <>
      $1C: <
      $1D:  AND
      $1E:  OR
      $1F:  MOD
      $20: ^
      $22: (
      $23: , 
      $24, 
      $25:  THEN
      $26, 
      $27: , 
      $28, $29: \"
      $2A: (
      $2D: (
      $2E:  PEEK
      $2F: RND
      $30: SGN
      $31: ABS
      $32: PDL
      $34: (
      $35: +
      $36: -
      $37: NOT
      $38: (
      $39: =
      $3A: #
      $3B: LEN (
      $3C: ASC (
      $3D: SCRN (
      $3E: , 
      $3F:  (
      $40: $
      $42: (
      $43, 
      $44: , 
      $45, 
      $46, 
      $47: ;
      $48, 
      $49: , 
      $4A: , 
      $4B: TEXT
      $4C: GR
      $4D: CALL
      $4E, 
      $4F: DIM
      $50: TAB
      $51: END
      $52,  $53,  $54: INPUT
      $55: FOR
      $56:  =
      $57:  TO
      $58:  STEP
      $59: NEXT
      $5A: , 
      $5B: RETURN
      $5C: GOSUB
      $5D: REM
      $5E: LET
      $5F: GOTO
      $60: IF
      $61, 
      $62: PRINT
      $63: PRINT
      $64:   POKE
      $65: , 
      $66: COLOR=
      $67: PLOT
      $68: , 
      $69: HLIN
      $6A: , 
      $6B:  AT
      $6C: VLIN
      $6D: , 
      $6E:  AT
      $6F: VTAB
      $70, 
      $71:  =
      $72: )
      $74: LIST
      $75: , 
      $77: POP
      $79: NO DSP
      $7A: NO TRACE
      $7B, 
      $7C: DSP
      $7D: TRACE
      $7E: PR #
      $7F: IN #
*/
    

void addlist(void *_base,LINE *item)
{
	LINE **base = _base;
	LINE *q;

	item -> next = NULL;
	if (!*base)
		*base = item;
	else
	{
		q = *base;
		while (q -> next)
			q = q -> next;
		q -> next = item;
	}
}

int main(int argc,char *argv[])
{
	FILE *fil;
	LINE *ln;
	LINE *tmp;
	int line;
	short size;
	unsigned char c;
	unsigned char c_length;
	unsigned char c_eight;
	unsigned char c_line1;
	unsigned char c_line2;

	if (argc < 2)
	{
		printf("Usage: %s <file>\n",*argv);
		exit(-1);
	}
	blockptr = 0;
	dataptr = 0;
	if ((fil = fopen(argv[1],"rb")) != NULL)
	{
		fread(&size,1,2,fil);	// 2 bytes size
		while (!feof(fil))
		{
			fread(&c_length,1,1,fil);
			fread(&c_eight,1,1,fil);
			if (!c_eight)
			{
				break;
			}
			fread(&c_line1,1,1,fil);
			fread(&c_line2,1,1,fil);
			line = (((int)c_line2) << 8) + c_line1;
			fread(&c,1,1,fil);
			*the_str = 0;
			while (c && !feof(fil))
			{
				if (c >= 128)
  					sprintf(the_str + strlen(the_str)," %s ",applesoft_tokens[c - 128]);
				else
  					sprintf(the_str + strlen(the_str),"%c",c);
				fread(&c,1,1,fil);
			}
			ln = (LINE *)malloc(sizeof(LINE));
			ln -> line = line;
			ln -> blockptr = blockptr;
			ln -> the_str = (char *)malloc(strlen(the_str) + 1);
			strcpy(ln -> the_str,the_str);
			addlist(&linebase,ln);
			the_ptr = 0;
//			yyparse();
		}
		fclose(fil);
		for (ln = linebase; ln; ln = tmp)
		{
			printf("%4d %s\n",ln -> line,ln -> the_str);
			tmp = ln -> next;
			free(ln -> the_str);
			free(ln);
		}
	} else
	{
		printf("%s: Couldn't open '%s'...\n",*argv,argv[1]);
		exit(-2);
	}
}
